#!/usr/bin/env bash
echo -e "\nSourcing nextgen-stack/set-dev-envars.sh\n"
source ./nextgen/app.env
source ../nextgen-stack/set-dev-envars.sh

# Stop the nextgen stack if requested
STOP_NEXTGEN_STACK=$1
if [[ $STOP_NEXTGEN_STACK = true ]]; then
    echo -e "\nStopping nextgen-stack"
    export TAIL_LOGS=false
    pushd ../nextgen-stack
    ./stop-all.sh
    popd
fi

echo -e "\nStop and remove running VA FitHeart containers\n"
docker-compose -f ./nextgen/docker-compose-dev.yml down || { echo "FATAL: Failed to stop and remove running containers"; exit 1; }